#version 330
#extension GL_EXT_gpu_shader4 : enable
// ixd08_kaleidoscopeMod01.fsh  by ixd08

//https://www.shadertoy.com/view/7lBGDK
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415926535897932384626433832795

struct Triangle {
    vec2 v1;
    vec2 v2;
    vec2 v3;
};

#define S_RECT 0
#define S_ELLIPSE 1
#define S_TRIANGLE 3

struct Shape {
    int type;
    vec2 pos;
    float angle;
    vec2 size;
    vec3 color;
};

vec4 drawShape(Shape shape, vec2 uv) {
    uv -= shape.pos;
    float c = cos(-shape.angle);
    float s = sin(-shape.angle);
    mat2 m = mat2(c, s, -s, c);
    uv = m * uv;
    uv /= shape.size / 2.0;
    if (shape.type == S_RECT) {
        if (abs(uv.x) <= 1.0 && abs(uv.y) <= 1.0) {
            return vec4(shape.color, 1.0);
        }
    } else if (shape.type == S_ELLIPSE) {
        if (dot(uv, uv) <= 1.0) {
            return vec4(shape.color, 1.0);
        }
    } else {
        if ((uv.y <= 1.0 + 2.0 * uv.x) && (uv.y <= 1.0 - 2.0 * uv.x) && (uv.y >= -1.0)) {
            return vec4(shape.color, 1.0);
        }
    }
    return vec4(0);
}

float rand(int a, int b) {
    float x = float(a * 100 + b);
    return fract(abs(sin(15123.9847 * x) * 9234.3521));
}


vec3 baseImage(vec2 uv) {
    for (int i = 0; i < 100; ++i) {
        vec2 A = vec2( rand(i,1)*2.0, rand(i,2)*2.0 );
        vec2 k = vec2( rand(i,3)*0.3, rand(i,4)*0.3 );
        vec2 pos = vec2( rand(i,5), rand(i,6) ) + A*sin(k*iTime);
        vec2 size = vec2( rand(i,7)*0.2+0.1, rand(i,8)*0.2+0.1);
        float angle = rand(i,9)*2.0*PI + (rand(i,10)*2.0-1.0)*PI*iTime;
        vec3 color = vec3( rand(i,11)*0.9, rand(i,12)*0.9, rand(i,13)*0.9);
        float r = rand(i,14);
        int type;
        if (r < 0.4) {
            type = S_RECT;
        } else if (r < 0.6) {
            type = S_ELLIPSE;
        } else {
            type = S_TRIANGLE;
        }
        Shape s = Shape(type, pos, angle, size, color);
        vec4 col = drawShape(s, uv);
        if (col.a > 0.0) {
            return col.rgb;
        }
    }
    
    return vec3(0);
}


/*
vec3 baseImage(vec2 uv) {
    if (distance(uv, vec2(0, 0)) < 0.2) {
        return vec3(0, 1, 1);
    }
    if (distance(uv, vec2(1, 0)) < 0.2) {
        return vec3(1, 1, 0);
    }
    if (distance(uv, vec2(0.5, 1.0)) < 0.2) {
        return vec3(1, 0, 0);
    }
    return vec3(uv.y, uv.x, 1.0 - uv.x);
    //return vec3(0);
}
*/

// p -> q
vec2 mapTriangle(vec2 uv, Triangle p, Triangle q) {
    mat2 LP = mat2(p.v2 - p.v1, p.v3 - p.v1);
    mat2 LQ = mat2(q.v2 - q.v1, q.v3 - q.v1);
    return LQ * inverse(LP) * (uv - p.v1) + q.v1;
}

// triangle
vec2 uvKaleidoscope0(vec2 uv) {
    uv.y = mod(uv.y, 2.);
    if (uv.y > 1.) {
        uv.y = 2.-uv.y;
    }
    uv.x *= sqrt(3.) / 2.;
    uv.x -= 0.5 * uv.y;
    uv.x = mod(uv.x, 3.);
    Triangle q = Triangle(vec2(0, 0), vec2(1, 0), vec2(.5, sqrt(3.0) / 2.0));
    Triangle p;
    if (uv.x < 1.) {
        if (uv.y < 1.-uv.x) {
            p = Triangle(vec2(0, 0), vec2(1, 0), vec2(0, 1));
        } else {
            p = Triangle(vec2(1, 1), vec2(1, 0), vec2(0, 1));
        }
    } else if (uv.x < 2.) {
        uv.x -= 1.;
        if (uv.y < 1. - uv.x) {
            p = Triangle(vec2(0, 1), vec2(0, 0), vec2(1, 0));
        } else {
            p = Triangle(vec2(0, 1), vec2(1, 1), vec2(1, 0));
        }
    } else {
        uv.x -= 2.;
        if (uv.y < 1. - uv.x) {
            p = Triangle(vec2(1, 0), vec2(0, 1), vec2(0, 0));
        } else {
            p = Triangle(vec2(1, 0), vec2(0, 1), vec2(1, 1));
        }
    }
    uv = mapTriangle(uv, p, q);
    return uv;
}

// square
vec2 uvKaleidoscope1(vec2 uv) {
    uv = mod(uv, 2.);
    
    if (uv.y > 1.) {
        uv.y = 2. - uv.y;
    }
    if (uv.x > 1.) {
        uv.x = 2. - uv.x;
    }
    if (uv.y > 1. - uv.x) {
        Triangle p = Triangle(vec2(1, 1), vec2(1, 0), vec2(0, 1));
        Triangle q = Triangle(vec2(0, 0), vec2(1, 0), vec2(0, 1));
        uv = mapTriangle(uv, p, q);
    }
    return uv;
}

// hexagon
vec2 uvKaleidoscope2(vec2 uv) {
    uv.y = mod(uv.y, 2.);
    if (uv.y > 1.) {
        uv.y = 2.-uv.y;
    }
    uv.x *= sqrt(3.) / 2.;
    uv.x -= 0.5 * uv.y;
    uv.x = mod(uv.x, 3.);
    Triangle q = Triangle( vec2(0.5,1.0), vec2(0.5-1.0/sqrt(3.0),0.0), vec2(0.5,0.0) );
    Triangle p;
    if (uv.x < 1.) {
        if (uv.y < 1.-uv.x) {
            if (uv.y < uv.x) {
                p = Triangle( vec2(0,0), vec2(1,0), vec2(0.5,0.5) );
            } else {
                p = Triangle( vec2(0,0), vec2(0,1), vec2(0.5,0.5) );
            }
        } else {
            if (uv.y < uv.x) {
                p = Triangle( vec2(1,1), vec2(1,0), vec2(0.5,0.5) );
            } else {
                p = Triangle( vec2(1,1), vec2(0,1), vec2(0.5,0.5) );
            }
        }
    } else if (uv.x < 2.) {
        uv.x -= 1.;
        if (uv.y < 1.0 - 2.0 * uv.x) {
            p = Triangle( vec2(0,1), vec2(0,0), vec2(0.5,0.0) );
        } else if (uv.y < 1.0 - uv.x) {
            p = Triangle( vec2(0,1), vec2(1,0), vec2(0.5,0.0) );
        } else if (uv.y < 1.0 - 0.5 * uv.x) {
            p = Triangle( vec2(0,1), vec2(1,0), vec2(1.0,0.5) );
        } else {
            p = Triangle( vec2(0,1), vec2(1,1), vec2(1.0,0.5) );
        }
    } else {
        uv.x -= 2.;
        if (uv.y < 0.5 - 0.5 * uv.x) {
            p = Triangle( vec2(1,0), vec2(0,0), vec2(0.0,0.5) );
        } else if (uv.y < 1.0 - uv.x) {
            p = Triangle( vec2(1,0), vec2(0,1), vec2(0.0,0.5) );
        } else if (uv.y < 2.0 - 2.0 * uv.x) {
            p = Triangle( vec2(1,0), vec2(0,1), vec2(0.5,1.0) );
        } else {
            p = Triangle( vec2(1,0), vec2(1,1), vec2(0.5,1.0) );
        }
    }
    uv = mapTriangle(uv, p, q);
    return uv;
}

// octagon
vec2 uvKaleidoscope3(vec2 uv) {
    uv = mod(uv, 3.0);
    uv /= 3.0;
    
    if (uv.y > 0.5) {
        uv.y = 1.0 - uv.y;
        uv.x = 1.0 - uv.x;
    }
    if (uv.x > 0.5) {
        uv.x = 1.0 - uv.x;
        uv = uv.yx;
    }
    if (uv.y > 0.5 - uv.x) {
        uv.x = 0.5 - uv.x;
        uv.y = 0.5 - uv.y;
        uv = uv.yx;
    }
    
    float a = 1.0 / (cos(PI / 8.0) / sin(PI / 8.0) + 1.0);
    float r = a / (2.0 * sin(PI / 8.0));
    float h = a / (2.0 * tan(PI / 8.0));
    
    Triangle p;
    if (uv.y > h) {
        p = Triangle(vec2(0.0, h + a / 2.0), vec2(a / 2.0, h), vec2(-a / 2.0, h));
    } else if (uv.y > 2.0 * h / a * uv.x) {
        p = Triangle(vec2(0, 0), vec2(a / 2.0, h), vec2(-a / 2.0, h)); 
    } else if (uv.x > h) {
        p = Triangle(vec2(h + a / 2.0, 0.0), vec2(h, -a / 2.0), vec2(h, a / 2.0));
    } else if (uv.y < a / (2.0 * h) * uv.x) {
        p = Triangle(vec2(0, 0), vec2(h, -a / 2.0), vec2(h, a / 2.0));
    } else {
        p = Triangle(vec2(0, 0), vec2(a / 2.0, h), vec2(h, a / 2.0));
    }
    
    Triangle q = Triangle(vec2(0.5, 1.0), vec2(0, 0), vec2(1, 0));
    
    uv = mapTriangle(uv, p, q);
    
    return uv;
}

// oct star
vec2 uvKaleidoscope4(vec2 uv) {
    uv = mod(uv, 5.0);
    uv /= 5.0;
    
    if (uv.y >= 0.5) {
        uv.y = 1.0 - uv.y;
    }
    if (uv.x >= 0.5) {
        uv.x = 1.0 - uv.x;
    }
    if (uv.y > uv.x) {
        uv = uv.yx;
    }
    
    float a = 1.0 / (3.0 * cos(PI / 8.0) / sin(PI / 8.0) + 1.0);
    float r = a / (2.0 * sin(PI / 8.0));
    float h = a / (2.0 * tan(PI / 8.0));
    
    Triangle p;
    if (uv.x < h + a / 2.0 || uv.y < 2.0 * h - uv.x) {
        if (uv.y > (h - a / 2.0) / (h + a / 2.0) * uv.x) { 
            p = Triangle(vec2(0, 0), vec2(h + a / 2.0, h - a / 2.0), vec2(h + a / 2.0));
        } else {
            p = Triangle(vec2(0, 0), vec2(h + a / 2.0, h - a / 2.0), vec2(0.5 - h - a / 2.0, 0.0));
        }
    } else if (uv.y > 2.0 * h || uv.y > 0.5 + h + a / 2.0 - uv.x) {
        if (uv.y > (uv.x - 2.0 * h) * 2.0 * h / a) {
            p = Triangle(vec2(0.5, 0.5), vec2(2.0 * h), vec2(0.5 - h + a / 2.0, 2.0 * h));
        } else {
            p = Triangle(vec2(0.5, 0.5), vec2(0.5, h + a / 2.0), vec2(0.5 - h + a / 2.0, 2.0 * h));
        }
    } else if (uv.y < uv.x - 2.0 * h - a) {
        p = Triangle(vec2(0.5, 0.0), vec2(2.0 * h + a, 0.0), vec2(0.5, h - a / 2.0));
    } else {
        p.v1 = vec2(2.0 * h + a / 2.0, h);
        vec2 d = uv - p.v1;
        float ang = atan(d.y, d.x);
        ang += PI / 8.0;
        float n = floor(ang / PI * 4.0);
        ang = n * PI / 4.0 + PI / 8.0;
        p.v2 = p.v1 + vec2(r * cos(ang), r * sin(ang));
        ang -= PI / 4.0;
        p.v3 = p.v1 + vec2(r * cos(ang), r * sin(ang));
        if (mod(n, 2.0) > 0.5) {
            vec2 t = p.v2;
            p.v2 = p.v3;
            p.v3 = t;
        }
        
    }
    Triangle q = Triangle(vec2(0.5, 1.0), vec2(0, 0), vec2(1, 0));
    uv = mapTriangle(uv, p, q);
    
    return uv;
}

vec3 kaleidoscope(float id, vec2 uv) {
    id = mod(id, 5.0);
    if (id < 1.0) {
        return baseImage(uvKaleidoscope0(uv));
    }
    if (id < 2.0) {
        return baseImage(uvKaleidoscope1(uv));
    }
    if (id < 3.0) {
        return baseImage(uvKaleidoscope2(uv));
    }
    if (id < 4.0) {
        return baseImage(uvKaleidoscope3(uv));
    }
    return baseImage(uvKaleidoscope4(uv));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (gl_FragCoord.xy - iResolution.xy / 2.0) / iResolution.y;
    uv *= 7.0;
    
    vec3 col;
    float interval = 20.0;
    float mixTime = 1.0;
    float t = mod(iTime, interval);
    float id = iTime / interval;
    if (t < interval - mixTime) {
        col = kaleidoscope(id, uv);
    } else {
        vec3 c1 = kaleidoscope(id, uv);
        vec3 c2 = kaleidoscope(id + 1.0, uv);
        float factor = smoothstep(interval - mixTime, interval, t);
        col = mix(c1, c2, factor);
    }

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}
